/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "Stmt.h"

Stmt::~Stmt()
{
}


void Stmt::Emit(Bytecode &b)
{
	// this is where to hook general-purpose emit code that
	// applies to all statements.  For now, just call EmitActual()
	EmitActual(b);
}


bool Stmt::Check(CheckState &state)
{
	bool ok = true;
	
	for(Stmt *s = GetChildren(); s; s=s->GetNext())
		if (!s->Check(state))
			ok = false;
			
	return ok;
}

void Stmt::EmitSwitchCases(Bytecode & b, SwitchState & state)
{
	Stmt *s;
	
	for(s=GetChildren(); s; s=s->GetNext())
		s->EmitSwitchCases(b, state);
}


Stmt* LeafStmt::GetChildren()
{
	return 0;
}


ChainStmt::~ChainStmt()
{
	delete fBody;
}


Stmt* ChainStmt::GetChildren()
{
	return fBody;
}
