/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __ControlStmt_h
#define __ControlStmt_h

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

class Clause;

// types for TestCond
enum
{
	kLessOrEqual = 0,
	kGreaterOrEqual,
	kNotEqualTo,
	kEqualTo,
	kGreaterThan,
	kLessThan
};


// types for CompCond
typedef enum
{
	kCompOr = 0,
	kCompAnd
} CompCondType;

class Bytecode;
class Mapping;

class Condition : public AutoFree
{
public:
	virtual	~Condition();
	
	virtual void	Invert() = 0;
	virtual void	Emit(Bytecode &b, int label) = 0;
	virtual Condition* Clone(Mapping *) const = 0;
	
	virtual bool	Evaluate(bool &value) const = 0;

			void	EmitInv(Bytecode &b, int label);
};


class TestCond : public Condition
{
public:
			TestCond(Clause *left, int relation, Clause *right);
			~TestCond();
			
	virtual bool	Evaluate(bool &value) const;

	void	Invert();

	void	Emit(Bytecode &b, int label);
	Condition*	Clone(Mapping *b) const;

	int		GetRelation() const	{ return fRelation; }

	
private:
	Clause*		fLeft;
	Clause*		fRight;
	int			fRelation;
};


class ConstCond : public Condition
{
public:
			ConstCond(bool v)	{ fValue = v; }

	virtual bool	Evaluate(bool &value) const;

	void	Invert();
	void	Emit(Bytecode &b, int label);
	Condition*	Clone(Mapping *b) const;

private:
	bool	fValue;
};


class CompCond : public Condition
{
public:
			CompCond(Condition *c1, CompCondType type, Condition *c2);
			~CompCond();
			
	virtual bool	Evaluate(bool &value) const;

	void	Invert();
	void	Emit(Bytecode &b, int label);
	Condition*	Clone(Mapping *b) const;

private:
	Condition*	fC1;
	CompCondType fType;
	Condition*	fC2;
};


#endif
