/*
 * C compatible standard library
 * Copyright 1998-2000 (C) Eiichiroh Itoh
 *
 * 1997/11/06:Eiichiroh Itoh
 *  (1) Initial development
 * Modification
 * 1998/04/03:Eiichiroh Itoh
 *  (1) modify for POBox
 * 1999/12/23:Eiichiroh Itoh
 *  (1) add CEFILE structure and modify related function
 * 2000/01/05:Eiichiroh Itoh
 *  (1) add fprintf function
 * 2000/02/26:Eiichiroh Itoh
 *  (1) fix bug about nBufSize in Fgetc
 *
 */
#ifndef	APP_TOOLS1
#define	APP_TOOLS1

#include	<windows.h>
#include	<tchar.h>
#include	<string.h>

#define	NO_CLIPBOARD
#define	NO_DIR
#define	NO_STRING

#define	NUM_CEFILE		16
#define	CE_stdin		(&g_CEFILE[0])
#define	CE_stdout		(&g_CEFILE[1])
#define	CE_stderr		(&g_CEFILE[2])
#define	CE_EOF			(-1)

#undef	EOF
#define	EOF				CE_EOF
#define	FILE			CEFILE
#define	fopen			Fopen
#define	fclose			Fclose
#define	fgetc			Fgetc
#define	getc			Fgetc
#define	fputc			Fputc
#define	putc			Fputc
#define	fgets			Fgets
#define	fputs			Fputs
#define	fread(buf,sz1,sz2,fp)	Fread((buf),(sz1)*(sz2),(fp))
#define	fwrite(buf,sz1,sz2,fp)	Fwrite((buf),(sz1)*(sz2),(fp))
#define	fseek			Fseek
#define	feof			Feof
#define	fflush			Fflush
#define	printf			Printf
#define	sprintf			Sprintf
#define	fprintf			Fprintf
#define	exit			Exit

#define	stdin			CE_stdin
#define	stdout			CE_stdout
#define	stderr			CE_stderr

#ifndef	SEEK_CUR
#define	SEEK_CUR	1
#define	SEEK_END	2
#define	SEEK_SET	0
#endif	/* SEEK_CUR */

#define	EXCEPTION_QUIT	(1)

typedef struct {
	union {
		HANDLE	m_hfile ;
		HWND	m_hwnd ;
	} handle ;
	BOOL	m_bUse ;
	BOOL	m_bHwnd ;
	BOOL	m_bEof ;
	BOOL	m_bBinary ;
	BOOL	m_bError ;
	DWORD	m_dwRin ;
	DWORD	m_dwRout ;
	DWORD	m_dwRsize ;
	DWORD	m_dwWin ;
	BOOL	m_bReadDone ;
	LPBYTE	m_rBuf ;
	BYTE	m_sBuf[ 256 ] ;
} CEFILE ;

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	UNICODE
int		Mbstowcs( LPTSTR szUnicode, LPCSTR szSjis, int nSize ) ;
int		Wcstombs( LPSTR szSjis, LPCTSTR szUnicode, int nSize ) ;
#endif	/* UNICODE */
CEFILE*	Fopen( LPCSTR path, LPCSTR modestr ) ;
CEFILE*	FopenW( LPCTSTR path, LPCTSTR modestr ) ;
void	Fclose( CEFILE *fp ) ;
int		Fgetc( CEFILE *fp ) ;
char*	Fgets( char *buf, int size, CEFILE *fp ) ;
int		Fputc( int c, CEFILE *fp ) ;
int		Fputs( const char *buf, CEFILE *fp ) ;
int		Fread( void *buf, int size, CEFILE *fp ) ;
void	Fwrite( const void *buf, int size, CEFILE *fp ) ;
void	Fflush( CEFILE *fp ) ;
BOOL	Ferror( CEFILE *fp ) ;
int		Fseek( CEFILE *fp, long offset, int whence ) ;
DWORD	Fsize( CEFILE *fp ) ;
int		Feof( CEFILE *fp ) ;
void	AddStrToEditControl( HWND hwnd, LPCTSTR szUnicode ) ;
void	AttachWinToStream( CEFILE *fp, HWND hwnd ) ;

void	slash2backslash( LPTSTR str ) ;
void	catdir( LPTSTR body, LPCTSTR adddir, LPTSTR pPrevDir ) ;
void	rel2abs( LPTSTR newPath, LPCTSTR oldPath, LPCTSTR adddir ) ;
int		Sprintf( char *buf, const char *fmt, ... ) ;
int		Fprintf( CEFILE *fp, const char *fmt, ... ) ;
int		Printf( const char *fmt, ... ) ;
int		SendClipboard( const char *sjis ) ;
int		ReceiveClipboard( char *sjis ) ;
int		Exit( int exitcode ) ;

extern	CEFILE	g_CEFILE[ NUM_CEFILE ] ;

#ifdef	__cplusplus
} ;
#endif

#endif	/* APP_TOOLS1 */
