/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __PArray_h
#define __PArray_h

#ifdef	_WIN32
inline void *__cdecl operator new(size_t, void *_P) { return (_P); }
#else	/* _WIN32 */
#include <new.h>
#endif	/* _WIN32 */

#define kPArray_DoubleGrowStep	0

class P_Array
{
	public:
	
				P_Array(int itemSize);
		virtual	~P_Array();

		// normal functions that ignore the type contained in the array
		int		GetLength() const		{ return fLength; };
		void	SetLength(int count);	// grow according to fGrowStep, and never truncate
		void	Remove(int index, int count=1);								

		// advanced functions
		void	SetGrowStep(int g)		{ fGrowStep = g; }
		int		GetGrowStep() const		{ return fGrowStep; }
		void	Allocate(int n);		// hard allocation/truncation


	protected:
		void	InsertSpace(int index, int count=1);	// helpful when inserting an item

		int		fItemSize;
		int 	fGrowStep;
		int		fLength;
		int		fAllocated;
		char*	fContents;

	private:
		void	Construct(int index, int count);
		void	Destruct(int index, int count);

		virtual void Construct(char * /* p */)	{ return; }
		virtual void Destruct(char * /* p */)	{ return; }

};


template <class T>
class PArray : public P_Array
{
	public:
		PArray() : P_Array(sizeof(T)) 	{};

		const T&	operator[] (int i) const	{ return ((T*)fContents)[i]; }
		T&			operator[] (int i)			{ return ((T*)fContents)[i]; }
		void	Append(const T &t)			{ SetLength(fLength+1); ((T*)fContents)[fLength-1]=t; }
		void	Insert(int i, const T &t)	{ InsertSpace(i); ((T*)fContents)[i] = t; }
		T*		GetContents() const			{ return (T*)fContents; }

	private:
		void	Construct(char *p)	{ new ((T*)p) T(); }
		void 	Destruct(char *p)	{ ((T*)p)->~T(); }
};

#endif
