/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __Stmt_h
#define __Stmt_h

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __AutoFree_h
#include "AutoFree.h"
#endif

class Bytecode;
class CheckState;
class Mapping;
class SwitchState;

/*
 * Stmt is the abstract base class for all program statements
 */
 
class Stmt :  public PLinkS<Stmt>, public AutoFree
{
public:
					Stmt()	{ fNullable = false; }
	virtual 		~Stmt();

//	virtual const Stmt*	GetChildren() const = 0;
	virtual Stmt*		GetChildren() = 0;

			// overall emit which will call the virtual EmitActual
			void	Emit(Bytecode &b);

	virtual bool	Check(CheckState &state);
	virtual void	EmitActual(Bytecode &b) = 0;
	
	virtual void	EmitSwitchCases(Bytecode &b, SwitchState &s);
	virtual Stmt*	Clone(Mapping *b) const = 0;

			bool	IsNullable() const	{ return fNullable; }
	

protected:
	bool	fNullable;
	
};


/*
 * LeafStmt is an abstract base class for statements that do not
 * contain any other statements as children.
 */

class LeafStmt : public Stmt
{
public:
	virtual Stmt*	GetChildren();
};


/*
 * ChainStmt is an abstract base class for statements that contain
 * a single child.  
 */

class ChainStmt : public Stmt
{
public:
					ChainStmt(Stmt *s=0)	: fBody(s) {}
					~ChainStmt();

	virtual Stmt*	GetChildren();

protected:
	Stmt*			fBody;
};

#endif
