/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __IfStmt_h
#define __IfStmt_h

#ifndef __Stmt_h
#include "Stmt.h"
#endif

#ifndef __Condition_h
#include "Condition.h"
#endif

class IfStmt : public Stmt
{
public:
			IfStmt(Condition *c, Stmt *s1, Stmt *s2=nil);
			~IfStmt();
	
	Stmt*	GetChildren();
	
	bool	Check(CheckState &state);
	void	EmitActual(Bytecode &b);
	Stmt*	Clone(Mapping *b) const;

private:
	void	EmitIf(Bytecode &b);
	void	EmitIfElse(Bytecode &b);
	
	Condition*	fCondition;
	Stmt*		fThen;
	Stmt*		fElse;
};


#endif
