/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __Bytecode_h
#define __Bytecode_h

#ifndef __PArray_h
#include "PArray.h"
#endif

#ifndef __PListS_h
#include "PListS.h"
#endif

#ifndef __PTypes_h
#include "PTypes.h"
#endif

#ifndef __JumpStmt_h
#include "JumpStmt.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

class RCX_Cmd;

// Fixup types
#define kPatch_Normal	0
#define kPatch_SignBit	1

#define kCurrentPosition	-1
#define kIllegalLabel		-1

class VarPool;
class RCX_Target;

class Bytecode
{
public:	
				Bytecode(VarPool &varPool, bool tempsAllowed, const RCX_Target *target);
				~Bytecode();

	int				GetLength()	const	{ return fData.GetLength(); }
	const UByte*	GetData() const		{ return fData.GetContents(); }
	
	void		Add(const UByte *data, int count);
	void		Add(const RCX_Cmd &cmd);
	void		AddJump(int label);
	void		AddTest(RCX_Value v1, RCX_Relation rel, RCX_Value v2, int label);
	void		AddMove(int dst, RCX_Value ea);
	
	int			NewLabel();
	void		SetLabel(int label, int target = kCurrentPosition);
	void		AddFixup(int type, UShort location, int label);
	void		ApplyFixups();
	
	void		PushLoopContext(bool continueAllowed=true);
	void		PopLoopContext(int continueTarget, int breakTarget);
	int			GetContinueLabel() const;
	int			GetBreakLabel() const;
	
	int			GetReturnLabel() const	{ return fReturnLabel; }
	void		SetReturnLabel(int l)	{ fReturnLabel = l; }
	
	int			GetTempVar();
	bool		TempsAllowed() const	{ return fTempsAllowed; }
	void		ReleaseTempEA(RCX_Value ea);
	bool		IsTempEA(RCX_Value ea);
	
	const RCX_Target*	Target() const	{ return fTarget; }
	
private:
	class Fixup : public PLinkS<Fixup>
	{
	public:
		int 	fType;
		UShort	fLocation;
		int		fLabel;
	};
	
	class LoopContext : public PLinkS<LoopContext>
	{
	public:
		int		fContinueLabel;
		int		fBreakLabel;
	};

	PArray<UByte>	fData;
		
	PListSS<Fixup>		fFixups;
	PArray<UShort>		fLabels;

	PListSS<LoopContext>	fLoopContexts;
	int					fReturnLabel;
	
	VarPool&	fVarPool;
	bool		fTempsAllowed;
	const RCX_Target*	fTarget;
};

#endif
