/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include <string.h>
#include "AssignStmt.h"
#include "RCX_Cmd.h"
#include "Bytecode.h"
#include "Clause.h"
#include "Mapping.h"

#define MATH_MASK	(TYPEMASK(kRCX_VariableType) + \
					TYPEMASK(kRCX_ConstantType))

AssignStmt::AssignStmt(int var, RCX_VarCode code, Clause * value)
 :	fVar(var),
	fCode(code),
	fValue(value)
{
}


AssignStmt::~AssignStmt()
{
	delete fValue;
}


void AssignStmt::EmitActual(Bytecode &b)
{
	if (fCode == kRCX_SetVar)
	{
		fValue->EmitTo(b, fVar);
	}
	else
	{
		RCX_Value ea = fValue->EmitConstrained(b, MATH_MASK);
		if (ea != Expr::kIllegalEA)
		{
			RCX_Cmd cmd;
			cmd.MakeVar(fCode, (UByte)fVar, ea);
			b.Add(cmd);
			b.ReleaseTempEA(ea);
		}
	}
}


Stmt* AssignStmt::Clone(Mapping *m) const
{
	int newVar = m ? m->Translate(fVar) : fVar;
	
	return new AssignStmt(newVar, fCode, fValue->Clone(m));
}
