/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#ifndef __AsmStmt_h
#define __AsmStmt_h

#ifndef __Stmt_h
#include "Stmt.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

#ifndef __RCX_Constants_h
#include "RCX_Constants.h"
#endif

class Clause;
class Field;
class Expr;


class Field : public PLinkS<Field>, public AutoFree
{
public:
	virtual	~Field();

	virtual Field*	Clone(Mapping *m) const = 0;
	virtual void	PreEmit(Bytecode &)		{};
	virtual void	Emit(Bytecode &b) const = 0;

private:
};


class AsmStmt : public LeafStmt
{
public:
				~AsmStmt();

	void		EmitActual(Bytecode &b);
	bool		Check(CheckState &state);
	Stmt*		Clone(Mapping *b) const;
	
	void		Add(Field *f)	{ fFields.InsertTail(f); }
private:
	PListS<Field>	fFields;
};




class ConstField : public Field
{
public:
			ConstField(Expr *e) : fValue(e) {};
			~ConstField();

	virtual Field*		Clone(Mapping *m) const;
	virtual void		Emit(Bytecode &b) const;

private:
	Expr*	fValue;
};


class EAField : public Field
{
public:
		enum
		{
			kSmallOperand =	0x1000000,
			kNoTypeCode =	0x2000000
		};

			EAField(Clause *c, int restrictor);
			~EAField();

	virtual Field*	Clone(Mapping *m) const;
	virtual void	PreEmit(Bytecode &b);
	virtual void	Emit(Bytecode &b) const;

private:
	Clause*	fClause;
	int		fRestrictor;
	RCX_Value	fEA;
};


#endif
