/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */

#include "AsmStmt.h"
#include "Bytecode.h"
#include "Clause.h"



AsmStmt::~AsmStmt()
{
#ifdef	_WIN32
	Field	*f ;
	while(f = fFields.RemoveHead())
		delete f;
#else	/* _WIN32 */
	while(Field *f = fFields.RemoveHead())
		delete f;
#endif	/* _WIN32 */
}


bool AsmStmt::Check(CheckState & /* state */)
{
	fNullable = !fFields.GetHead();
	return true;
}


void AsmStmt::EmitActual(Bytecode &b)
{
	Field *f;
	
	for(f = fFields.GetHead(); f; f=f->GetNext())
		f->PreEmit(b);
	
	for(f = fFields.GetHead(); f; f=f->GetNext())
		f->Emit(b);
}


Stmt* AsmStmt::Clone(Mapping *m) const
{
	AsmStmt *a = new AsmStmt();
	
	for(Field *f = fFields.GetHead(); f; f=f->GetNext())
		a->Add(f->Clone(m));
	
	return a;
}

Field::~Field()
{
}


ConstField::~ConstField()
{
	delete fValue;
}


Field* ConstField::Clone(Mapping *m) const
{
	return new ConstField(fValue->Clone(m));
}


void ConstField::Emit(Bytecode &b) const
{
	int value;

	fValue->Evaluate(value);

	UByte byte = (UByte) value;
	b.Add(&byte, 1);
}

EAField::EAField(Clause *c, int restrictor) :
	fClause(c),
	fRestrictor(restrictor),
	fEA(Expr::kIllegalEA)
{
}


EAField::~EAField()
{
	delete fClause;
}


Field* EAField::Clone(Mapping *m) const
{
	return new EAField(fClause->Clone(m), fRestrictor);
}


void EAField::PreEmit(Bytecode &b)
{
	fEA = fClause->EmitConstrained(b, fRestrictor);
}


void EAField::Emit(Bytecode &b) const
{
	UByte data[3];
	UByte *ptr = data;
	
	if (!(fRestrictor & kNoTypeCode))
		*ptr++ = (UByte) RCX_VALUE_TYPE(fEA);
	
	*ptr++ = (UByte) RCX_VALUE_DATA(fEA);
	
	if (!(fRestrictor & kSmallOperand))
		*ptr++ = (UByte) (RCX_VALUE_DATA(fEA) >> 8);
	
	b.Add(data, ptr-data);
	b.ReleaseTempEA(fEA);
}
